-- new script file

-- new script file
function OnAfterSceneLoaded(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    
    if not self.loaded then
      self.counted = false
    end
    
    self.startDefInc:LinkToTarget("defenderCounted")
    self.killDefDec:LinkToTarget("defenderKilled")
  end
  
  if not self.counted then
    self.counted = true
    self.startDefInc:TriggerAllTargets()
  end  
end

function OnBeforeDeath(self)
  self.killDefDec:TriggerAllTargets()
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.counted = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.counted)
  end
end

function CreateTriggerSources(self)
  self:AddTriggerSource("startDefInc")
  self:AddTriggerSource("killDefDec")
end
